//////////////////////////////////////////////////////////////////
//
// Header file for the Planar Motor Controller C++ library
// Version Number: 06.03.048.00
// Release Date: 27/11/2025 (DD/MM/YYYY)
// Change Log: - Override mode, zone speed and zone accel added to Zone_GetStatusEx
//             - Added PMC_MoverID_RegisterIDs
//             - Prefix for AppDesign commands shortened to App
//             - StationIDs for App commands are now 2 bytes long
//             - App_SendXbotToStation split into App_SendXbotToStation and App_SendXbotToStationSpeed
//             - GetFlywayTemp renamed to GetFlywayStatus (old name still present, but deprecated) 
//
//////////////////////////////////////////////////////////////////

#pragma once

#include "PMC_Cpp_API.h"

#include "EcMaster.h"

using namespace std;

namespace PMC
{
    class PMC_Acontis_API : public PMC_Cpp_API
    {
    private:
        
    public:
        PMC_Acontis_API(void);
        ~PMC_Acontis_API(void);
        /// @brief Finds PMCs on an Acontis EC Master
        /// @param ECInstanceID Instance ID of the EC Master to scan 
        /// @return List of found PMCs
        static FindPMCsRtn FindPMCs(PMC_DWORD ECInstanceID);
        /// @brief Connects to PMC. Must be called before using PMC commands
        /// @param ECInstanceID Instance ID of the EC Master with the PMC to connect to
        /// @param PMCIOIndex The station addresses (AutoInc) of the PMC to connect to
        /// @return 
        PMCRTN ConnectToPMC(PMC_DWORD ECInstanceID,PMC_UINT PMCIOIndex);
    };
}
